/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpunit_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpunit
 * @title: gimpunit
 * @short_description: Operations on units.
 *
 * Provides operations on units, a collection of predefined units and
 * functions to create new units.
 **/


/**
 * gimp_unit_new:
 * @name: The new unit's name.
 * @factor: The new unit's factor.
 * @digits: The new unit's digits.
 * @symbol: The new unit's symbol.
 * @abbreviation: The new unit's abbreviation.
 *
 * Creates a new unit.
 *
 * This procedure creates a new unit and returns it. Note that the new
 * unit will have it's deletion flag set to TRUE, so you will have to
 * set it to FALSE with gimp_unit_set_deletion_flag() to make it
 * persistent.
 *
 * Returns: (transfer none): The new unit.
 **/
GimpUnit *
gimp_unit_new (const gchar *name,
               gdouble      factor,
               gint         digits,
               const gchar *symbol,
               const gchar *abbreviation)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpUnit *unit = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_STRING, name,
                                          G_TYPE_DOUBLE, factor,
                                          G_TYPE_INT, digits,
                                          G_TYPE_STRING, symbol,
                                          G_TYPE_STRING, abbreviation,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-unit-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    unit = GIMP_VALUES_GET_UNIT (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return unit;
}

/**
 * _gimp_unit_get_data:
 * @unit_id: The unit's integer ID.
 * @factor: (out): The unit's factor.
 * @digits: (out): The unit's number of digits.
 * @symbol: (out) (transfer full): The unit's symbol.
 * @abbreviation: (out) (transfer full): The unit's abbreviation.
 *
 * Returns the various data pertaining to a given unit ID.
 *
 * This procedure returns all properties making up an unit. It is only
 * meant for internal usage to query non built-in units and it is a
 * programming error to use it directly, in particular for any of the
 * built-in units.
 *
 * Returns: (transfer full): The unit's name.
 *          The returned value must be freed with g_free().
 **/
gchar *
_gimp_unit_get_data (gint      unit_id,
                     gdouble  *factor,
                     gint     *digits,
                     gchar   **symbol,
                     gchar   **abbreviation)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gchar *name = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          G_TYPE_INT, unit_id,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-unit-get-data",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    {
      name = GIMP_VALUES_DUP_STRING (return_vals, 1);
      *factor = GIMP_VALUES_GET_DOUBLE (return_vals, 2);
      *digits = GIMP_VALUES_GET_INT (return_vals, 3);
      *symbol = GIMP_VALUES_DUP_STRING (return_vals, 4);
      *abbreviation = GIMP_VALUES_DUP_STRING (return_vals, 5);
    }

  gimp_value_array_unref (return_vals);

  return name;
}

/**
 * _gimp_unit_get_deletion_flag:
 * @unit: The unit.
 *
 * Returns the deletion flag of the unit.
 *
 * This procedure returns the deletion flag of the unit. If this value
 * is TRUE the unit's definition will not be saved in the user's unitrc
 * file on gimp exit.
 *
 * Returns: The unit's deletion flag.
 **/
gboolean
_gimp_unit_get_deletion_flag (GimpUnit *unit)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean deletion_flag = FALSE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_UNIT, unit,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-unit-get-deletion-flag",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    deletion_flag = GIMP_VALUES_GET_BOOLEAN (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return deletion_flag;
}

/**
 * _gimp_unit_set_deletion_flag:
 * @unit: The unit.
 * @deletion_flag: The new deletion flag of the unit.
 *
 * Sets the deletion flag of a unit.
 *
 * This procedure sets the unit's deletion flag. If the deletion flag
 * of a unit is TRUE on gimp exit, this unit's definition will not be
 * saved in the user's unitrc.
 *
 * Returns: TRUE on success.
 **/
gboolean
_gimp_unit_set_deletion_flag (GimpUnit *unit,
                              gboolean  deletion_flag)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_UNIT, unit,
                                          G_TYPE_BOOLEAN, deletion_flag,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-unit-set-deletion-flag",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
